/*
 * Handle client status requests
 */
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "libfma.h"
#include "lf_fms_comm.h"
#include "lf_channel.h"
#include "lf_fabric.h"

#include "fms.h"
#include "fms_error.h"
#include "fms_fabric.h"
#include "fms_client.h"

/*
 * Handle a status query
 */
int
fms_client_query_status(
  struct fms_client_desc *cdp)
{
  struct fms_query_status *msg;
  struct lf_fms_status_msg reply;
  struct lf_fabric *fp;
  int rc;

  fp = F.fabvars->fabric;
  memset(&reply, 0, sizeof(reply));

  /* get a pointer to the query message */
  msg = &(cdp->cl_msgbuf->query_status);

  /* Fill in status */
  reply.hosts_known_32 = htonl(fp->num_hosts);
  reply.fmas_found_32 = htonl(F.fabvars->num_fmas);
  reply.unacked_alerts_32 = htonl(fms_alert_count(FALSE, TRUE));

  /* See if mapping is in progress or pending*/
  if (FMS_FABRIC(fp)->request_map_adp != NULL
      || FMS_FABRIC(fp)->push_map_task != NULL
      || FMS_FABRIC(fp)->request_map_task != NULL) {
    reply.mapping_complete_8 = FALSE;
  } else {
    reply.mapping_complete_8 = TRUE;
  }
  strcpy(reply.last_mapper, FMS_FABRIC(fp)->last_mapper);

  /* see if the database is complete */
  if (!reply.mapping_complete_8) {
    reply.db_complete_8 = FALSE;
  } else {
    reply.db_complete_8 = fms_db_complete();
  }

  /* send status reply */
  rc = send(cdp->chp->fd, &reply, sizeof(reply), 0);
  if (rc != sizeof(reply)) LF_ERROR(("Error ending status reply to client"));

  return 0;

 except:
  return -1;
}
